/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.lonelyPeripherals;

import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockEntityLookingImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockEntityRedstoneImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockEntityRightClickImpetus;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class ImpetusPeripheral
implements IPeripheral {
    private BlockEntityAbstractImpetus impetus;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    public ImpetusPeripheral(BlockEntityAbstractImpetus _impetus) {
        this.impetus = _impetus;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public String getType() {
        if (this.impetus instanceof BlockEntityLookingImpetus) {
            return "fletcher_impetus";
        }
        if (this.impetus instanceof BlockEntityRedstoneImpetus) {
            return "cleric_impetus";
        }
        if (this.impetus instanceof BlockEntityRightClickImpetus) {
            return "toolsmith_impetus";
        }
        return "impetus";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final MethodResult getMedia() {
        return MethodResult.of((Object)this.impetus.getMedia());
    }

    @LuaFunction
    public final MethodResult getRemainingMediaCapacity() {
        return MethodResult.of((Object)this.impetus.remainingMediaCapacity());
    }

    @LuaFunction
    public final MethodResult getLastMishap() {
        class_2561 mishap = this.impetus.getDisplayMsg();
        if (mishap == null) {
            return MethodResult.of((Object)"");
        }
        return MethodResult.of((Object)mishap.getString());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getCaster() {
        UUID casterUUID = null;
        class_1937 class_19372 = this.impetus.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 sWorld = (class_3218)class_19372;
            CircleExecutionState state = this.impetus.getExecutionState();
            if (state != null && state.getCaster(sWorld) != null) {
                casterUUID = state.getCaster(sWorld).method_5667();
            } else {
                BlockEntityAbstractImpetus blockEntityAbstractImpetus = this.impetus;
                if (blockEntityAbstractImpetus instanceof BlockEntityRedstoneImpetus) {
                    BlockEntityRedstoneImpetus rsImpetus = (BlockEntityRedstoneImpetus)blockEntityAbstractImpetus;
                    casterUUID = rsImpetus.getStoredPlayer().method_5667();
                }
            }
        }
        if (casterUUID == null) {
            return MethodResult.of((Object)"");
        }
        return MethodResult.of((Object)casterUUID.toString());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult isCasting() {
        class_2338 pos;
        class_3218 sWorld;
        class_2680 state;
        class_2248 class_22482;
        class_1937 class_19372 = this.impetus.method_10997();
        if (class_19372 instanceof class_3218 && (class_22482 = (state = (sWorld = (class_3218)class_19372).method_8320(pos = this.impetus.method_11016())).method_26204()) instanceof ICircleComponent) {
            ICircleComponent comp = (ICircleComponent)class_22482;
            return MethodResult.of((Object)comp.isEnergized(pos, state, (class_1937)sWorld));
        }
        return MethodResult.of((Object)false);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult activateCircle() {
        BlockEntityAbstractImpetus blockEntityAbstractImpetus = this.impetus;
        if (blockEntityAbstractImpetus instanceof BlockEntityRedstoneImpetus) {
            BlockEntityRedstoneImpetus rsImpetus = (BlockEntityRedstoneImpetus)blockEntityAbstractImpetus;
            rsImpetus.startExecution(rsImpetus.getStoredPlayer());
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object)false);
    }

    public void impetusStarted() {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("circle_activated", new Object[]{computer.getAttachmentName()});
        }
    }

    public void impetusEnded() {
        class_2561 mishap = this.impetus.getDisplayMsg();
        String mishapString = "";
        if (mishap != null) {
            mishapString = mishap.getString();
        }
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("circle_stopped", new Object[]{mishapString, computer.getAttachmentName()});
        }
    }
}

